/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.art.export.diagrams.util;

public final class DiagramTextUtil {
    private static final int DEFAULT_AVG_CHAR_WIDTH = 7;
    private static final int DEFAULT_PADDING = 20;
    private static final int AVG_CHAR_WIDTH_LINUX = 8;
    private static final int PADDING_WINDOWS = 18;
    private static final int PADDING_LINUX = 22;
    private static final int PADDING_MAC = 24;
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    public static final boolean IS_WIN = OS_NAME.indexOf("windows") >= 0;
    public static final boolean IS_MAC = OS_NAME.indexOf("mac") >= 0;
    public static final boolean IS_LINUX = OS_NAME.indexOf("linux") >= 0;
    private static int averageCharWidth = DiagramTextUtil.getAverageCharWidth();
    private static int platformPadding = DiagramTextUtil.getPlatformPadding();

    private DiagramTextUtil() {
    }

    private static int getAverageCharWidth() {
        if (IS_LINUX) {
            return 8;
        }
        return 7;
    }

    private static int getPlatformPadding() {
        if (IS_WIN) {
            return 18;
        }
        if (IS_MAC) {
            return 24;
        }
        if (IS_LINUX) {
            return 22;
        }
        return 20;
    }

    public static int computeTextWidthPixels(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return text.length() * averageCharWidth;
    }

    public static double computeStateWidth(String stateName, double minWidth) {
        int textWidth = DiagramTextUtil.computeTextWidthPixels(stateName);
        double widthWithPadding = textWidth + platformPadding;
        return Math.max(minWidth, widthWithPadding);
    }
}

