/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.rsarte.art.exporter;

import com.hcl.art.export.diagrams.actions.ExportDiagramsAction;
import com.hcl.rsarte.art.exporter.ArtFileExportWizardPage;
import com.ibm.xtools.common.ui.wizards.internal.CommonUIWizardsPlugin;
import com.ibm.xtools.umldt.core.internal.util.UMLDTCoreUtil;
import com.ibm.xtools.umldt.ui.internal.actions.BuildWithServerAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class Uml2ArtExporter
extends Wizard
implements IExportWizard {
    public static final String ERROR_MSG = "Initialization of build server is disabled. Export to Art operation can't be performed. Change your workspace preferences.";
    private ArtFileExportWizardPage page;
    private String tcFilePath;
    static final String SETTINGS_SECTION_NAME = "ArtExporter";
    static final String sourceSelectionKey = "SourceSelections";
    static final String workspaceSelectedKey = "WorkspaceSelected";
    static final String directoryPathKey = "DirectoryPath";
    static final String workspacePathKey = "WorkspacePath";
    static final String exportDiagramsKey = "exportDiagrams";

    public Uml2ArtExporter() {
        this.setWindowTitle("Export");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setDialogSettings(this.createDialogSettings());
        this.setDefaultSettings();
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.restoreSettings();
    }

    protected IDialogSettings createDialogSettings() {
        IDialogSettings settings = CommonUIWizardsPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(this.getSettingsSectionName());
        if (section == null) {
            section = settings.addNewSection(this.getSettingsSectionName());
        }
        return section;
    }

    protected String getSettingsSectionName() {
        return SETTINGS_SECTION_NAME;
    }

    public boolean performFinish() {
        IPath path = new Path(this.page.getSourceSelection()).makeAbsolute();
        String destinationPath = this.page.getDestinationPath();
        boolean isExportDiagrams = this.page.isExportDiagramsSelected();
        this.saveSettings();
        ((WizardDialog)this.getContainer()).close();
        BuildWithServerAction.exportToArt((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(path), (String)destinationPath);
        if (isExportDiagrams) {
            new ExportDiagramsAction().exportDiagrams(ResourcesPlugin.getWorkspace().getRoot().getFile(path), destinationPath);
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public void addPages() {
        this.page = new ArtFileExportWizardPage();
        this.addPage((IWizardPage)this.page);
        this.page.setSelectedFile(this.tcFilePath);
    }

    public boolean canFinish() {
        boolean canFinish = this.page.isPageComplete() && !this.page.getDestinationPath().isEmpty();
        boolean isModelCompilerActive = UMLDTCoreUtil.isModelCompilerActive();
        if (!isModelCompilerActive) {
            this.page.setErrorMessage(ERROR_MSG);
        }
        return isModelCompilerActive && canFinish;
    }

    protected void setDefaultSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (settings.get(workspaceSelectedKey) == null) {
                settings.put(workspaceSelectedKey, false);
            }
            if (settings.get(directoryPathKey) == null) {
                settings.put(directoryPathKey, ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString() + File.separator + "CodeRT");
            }
            if (settings.get(workspacePathKey) == null) {
                settings.put(workspacePathKey, "");
            }
        }
    }

    private void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(sourceSelectionKey, this.page.getSourceSelection());
            settings.put(workspaceSelectedKey, this.page.isWorkspaceSelected());
            settings.put(workspacePathKey, this.page.getDefaultWorkspacePath());
            settings.put(directoryPathKey, this.page.getDefaultDirectoryPath());
            settings.put(exportDiagramsKey, this.page.isExportDiagramsSelected());
        }
    }

    private void restoreSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.page.setDefaultSourceSelection(settings.get(sourceSelectionKey));
        this.page.setWorkspaceSelected(settings.getBoolean(workspaceSelectedKey));
        this.page.setDefaultWorkspacePath(settings.get(workspacePathKey));
        this.page.setDefaultDirectoryPath(settings.get(directoryPathKey));
        this.page.setExportDiagramsOption(settings.getBoolean(exportDiagramsKey));
    }

    public void setTcFilePath(String tcFilePath) {
        this.tcFilePath = tcFilePath;
    }
}

